install.packages("timsac_1.3.8-4.zip", repos=NULL, type="source")
library("timsac")

o_comp <- read.csv("IbrkPWWT.csv",header=T)

t_comp <- matrix(0,nrow=575,ncol=9)
s_comp <- matrix(0,nrow=575,ncol=9)

colnames(t_comp) <- colnames(o_comp)
colnames(s_comp) <- colnames(o_comp)

t_comp[,1] <- o_comp[,1]
t_comp[,2] <- o_comp[,2]

s_comp[,1] <- o_comp[,1]
s_comp[,2] <- o_comp[,2]

for (i in 3:9) {wt <- ts(o_comp[,i], start=c(1973,5), frequency=12)
rslt <- decomp(wt, trend.order=1,ar.order=1, seasonal.order=1, log=FALSE, trade=FALSE, diff=1, miss=-999, omax=0,plot=FALSE)

      t_comp[,i] <- rslt$trend
      s_comp[,i] <- rslt$seasonal}

write.csv(t_comp,"IbrkPWWTTr.csv", quote=FALSE, row.names=FALSE)
write.csv(s_comp,"IbrkPWWTSs.csv", quote=FALSE, row.names=FALSE)
