document.addEventListener("DOMContentLoaded", function(){
    // Variables
    var buttonUp = document.querySelector('a[href="#up"]');
    
    var easings = {
        linear(t) {
            return t;
        },
        easeInQuad(t) {
            return t * t;
        },
        easeOutQuad(t) {
            return t * (2 - t);
        },
        easeInOutQuad(t) {
            return t < 0.5 ? 2 * t * t : -1 + (4 - 2 * t) * t;
        },
        easeInCubic(t) {
            return t * t * t;
        },
        easeOutCubic(t) {
            return (--t) * t * t + 1;
        },
        easeInOutCubic(t) {
            return t < 0.5 ? 4 * t * t * t : (t - 1) * (2 * t - 2) * (2 * t - 2) + 1;
        },
        easeInQuart(t) {
            return t * t * t * t;
        },
        easeOutQuart(t) {
            return 1 - (--t) * t * t * t;
        },
        easeInOutQuart(t) {
            return t < 0.5 ? 8 * t * t * t * t : 1 - 8 * (--t) * t * t * t;
        },
        easeInQuint(t) {
            return t * t * t * t * t;
        },
        easeOutQuint(t) {
            return 1 + (--t) * t * t * t * t;
        },
        easeInOutQuint(t) {
            return t < 0.5 ? 16 * t * t * t * t * t : 1 + 16 * (--t) * t * t * t * t;
        }
    };

    //読み込み時の高さに応じて表示非表示のセットを行うため
    isVisibled();

    // Functions
    /**
     * Animated scroll to up
     */
    function scrollUp(duration, easing) {
        var start = window.pageYOffset;
        var startTime = 'now' in window.performance ? performance.now() : new Date().getTime();
        var documentHeight = Math.max(document.body.scrollHeight, document.body.offsetHeight, document.documentElement.clientHeight, document.documentElement.scrollHeight, document.documentElement.offsetHeight);
        var windowHeight = window.innerHeight || document.documentElement.clientHeight || document.getElementsByTagName('body')[0].clientHeight;

        if ('requestAnimationFrame' in window === false) {
            window.scroll(0, 0);
            return;
        }
        // Animation
        function scroll() {
            var now = 'now' in window.performance ? performance.now() : new Date().getTime();
            var time = Math.min(1, ((now - startTime) / duration));
            var timeFunction = easings[easing](time);
            window.scroll(0, Math.ceil((timeFunction * (0 - start)) + start));
            if (window.pageYOffset === 0) {
                return;
            }
            requestAnimationFrame(scroll);
        }
        // Move
        scroll();
    }

    /**
     * Show and hide button
     */
    function isVisibled() {
        var heightHide = parseInt(buttonUp.getAttribute('height-hide')) || 100;
        if (document.body.scrollTop > heightHide || document.documentElement.scrollTop > heightHide) {
            
            //buttonUp.classList.remove('simplescrollup__button--hide');
            //buttonUp.classList.add('simplescrollup__button--show');
            
            // フェードインアニメーション

             // 対象にsimplescrollup__button--showのクラスがある場合は処理を行わない
            if (buttonUp.classList.contains('simplescrollup__button--show') == true) return;
            pageUpfadeIn(buttonUp,800);

        } else {
            // Hide
            //buttonUp.classList.remove('simplescrollup__button--show');
            //buttonUp.classList.add('simplescrollup__button--hide');

            // フェードアウトアニメーション

            // 対象にsimplescrollup__button--hideのクラスがある場合は処理を行わない
            if (buttonUp.classList.contains('simplescrollup__button--hide') == true) return;
            pageUpfadeOut(buttonUp,800);
        }
    }

    // Events

    // Click button
    buttonUp.addEventListener('click', function() {
        // Get attributes
        var duration = parseInt(buttonUp.getAttribute('duration')) || 1000;
        var easing = buttonUp.getAttribute('easing') || 'easeInOutQuad';
        // Run
        scrollUp(duration, easing);
    });

    // Auto show and hide button
    window.addEventListener('scroll', isVisibled);



    //フェードインアニメーション
    function pageUpfadeIn(node, duration) {

        // スタイル設定と透明度設定
        node.classList.remove('simplescrollup__button--hide');
        node.classList.add('simplescrollup__button--show');
        node.style.opacity = 0;

        var start = performance.now();
    
        requestAnimationFrame(function tick(timestamp) {
            // イージング計算式（linear）
            var easing = (timestamp - start) / duration;

            // opacityが1を超えないように
            node.style.opacity = Math.min(easing, 1);

            // opacityが1より小さいとき
            if (easing < 1) {
                requestAnimationFrame(tick);
            } else {
                node.style.opacity = 1;
            }
        });
    }

    //フェードアウトアニメーション
    function pageUpfadeOut(node, duration) {
        
        node.style.opacity = 1;
        var start = performance.now();
        
        requestAnimationFrame(function tick(timestamp) {
            // イージング計算式（linear）
            var easing = (timestamp - start) / duration;

            // opacityが0より小さくならないように
            node.style.opacity = Math.max(1 - easing, 0);
            
            // イージング計算式の値が1より小さいとき
            if (easing < 1) {
                requestAnimationFrame(tick);
            } else {
                node.style.opacity = 0;
                node.classList.remove('simplescrollup__button--show');
                node.classList.add('simplescrollup__button--hide');
            }
        });
    }

});